/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.mrp2;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import cz.insophy.inplan.mrp.CustomerRequest;
import cz.insophy.inplan.mrp.SupplyRequest;
import cz.insophy.inplan.mrp2.PropertyTransferer;
import cz.insophy.inplan.property.PropertyDefinition;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.superplan.Superplan;
import cz.insophy.inplan.util.Comparators;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class PrioPropertyTransferer
implements PropertyTransferer<Properties> {
    protected static final int SUPERFLUOUS_GOR_PRIORITY = 10;
    protected final PropertyDefinition rcttmProperty;
    protected final PropertyDefinition feedsProperty;
    protected final long ssTime;

    public PrioPropertyTransferer(Superplan superplan) {
        ShopConfiguration configuration = superplan.getShopConf();
        this.rcttmProperty = Preconditions.checkNotNull(configuration.getPropertyDefinition(GeneralizedOrderRequest.class, "rcttm"), "rcttm GOR property is required");
        this.feedsProperty = configuration.getPropertyDefinition(GeneralizedOrderRequest.class, "feeds");
        this.ssTime = superplan.getFixationDate();
    }

    @Override
    @Nonnull
    public Properties getProperties(@Nonnull CustomerRequest demand) {
        return new Properties(demand.getPriority(), demand.getTime(), 0L, demand.getId());
    }

    @Override
    @Nonnull
    public Properties getProperties(@Nonnull GeneralizedOrderRequest demand) {
        long rcttm = 0L;
        Long rcttmL = (Long)demand.getProperty(this.rcttmProperty);
        if (rcttmL != null) {
            rcttm = rcttmL;
        }
        return new Properties(demand.getPriority(), demand.getDueDate(), rcttm, demand.getId());
    }

    @Override
    @Nonnull
    public Properties getProperties(@Nonnull Material material) {
        return new Properties(10, this.ssTime, 0L, material.getName());
    }

    protected void setFeedsProperty(@Nonnull GeneralizedOrderRequest supply, @Nonnull List<Properties> demandsProps) {
        if (this.feedsProperty != null) {
            StringBuilder sb = new StringBuilder();
            for (Properties demandProps : demandsProps) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(demandProps.id);
            }
            supply.setProperty(this.feedsProperty, sb.toString());
        }
    }

    @Override
    public void setProperties(@Nonnull GeneralizedOrderRequest supply, @Nonnull List<Properties> demandsProps) {
        if (!demandsProps.isEmpty()) {
            Properties min2 = Collections.min(demandsProps);
            supply.setPriority(min2.priority);
            supply.setDueDate(min2.dueDate);
            supply.setProperty(this.rcttmProperty, min2.remainingCumulativeTtm + supply.getRemainingTimeToMake(true));
        } else {
            supply.setPriority(10);
        }
        this.setFeedsProperty(supply, demandsProps);
    }

    @Override
    public void setProperties(@Nonnull SupplyRequest supply, @Nonnull List<Properties> demandsProps) {
        if (demandsProps.isEmpty()) {
            supply.setState(SupplyRequest.State.CANCEL_PROPOSAL);
        }
    }

    protected static class Properties
    implements Comparable<Properties> {
        protected final int priority;
        protected final long dueDate;
        protected final long remainingCumulativeTtm;
        protected final String id;

        protected Properties(int priority, long dueDate, long remainingCumulativeTtm, String id) {
            this.priority = priority;
            this.dueDate = dueDate;
            this.remainingCumulativeTtm = remainingCumulativeTtm;
            this.id = id;
        }

        @Override
        public int compareTo(@Nonnull Properties o) {
            int res = Comparators.compare(this.priority, o.priority);
            if (res == 0) {
                res = Comparators.compare(this.dueDate - this.remainingCumulativeTtm, o.dueDate - o.remainingCumulativeTtm);
            }
            if (res == 0) {
                res = Comparators.compareNullsLast(this.id, o.id);
            }
            return res;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("priority", this.priority).add("dueDate", this.dueDate).add("remainingCumulativeTtm", this.remainingCumulativeTtm).add("id", this.id).toString();
        }
    }
}

